*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file updated for Nids Wave 4

* THIS IS 6th WEALTH DO FILE - RELEASE DO FILE: 6 OF 6
* THIS DO FILE PRODUCES THE VARIABLES AS THEY APPEAR IN THE PUBLIC RELEASE

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Wealth do file (1 of 6)"

version 13.0
*=====================================================================================================================================
* HOUSEHOLD LEVEL
* OPENING DATASET CREATED IN DO FILE "Wealth - Aggregation of imputation variables (5 of 6)"

use "$DataOUT\hhwealth.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------
keep w4_hhid re_ass b_ass v_ass f_ass s_ass lvstk_ass p_ass tot_ass re_deb b_deb v_deb f_deb tot_deb pi_re_ass ///
pi_b_ass pi_v_ass pi_f_ass pi_s_ass pi_lvstk_ass pi_p_ass pi_tot_ass pi_b_deb pi_v_deb pi_f_deb pi_tot_ass ///
pi_re_deb pi_b_deb pi_v_deb pi_f_deb pi_tot_deb hhq_networth pi_net_worth net_worth

lab var re_ass "Household Real Estate Assets"
lab var re_deb "Household Real Estate Debts"
lab var pi_re_ass "Household Pre-imputation Real Estate Assets"
lab var pi_re_deb "Household Pre-imputation Real Estate Debts"
lab var pi_b_ass "Household Pre-imputation Business Assets"
lab var pi_v_ass "Household Pre-imputation Vehicle Assets"
lab var pi_f_ass "Household Pre-imputation Financial Assets"
lab var pi_s_ass "Household Pre-imputation Retirement Annuity Assets"
lab var pi_lvstk_ass "Household Pre-imputation Livestock Assets"
lab var pi_p_ass "Household Pre-imputation Possessions"
lab var pi_b_deb "Household Pre-imputation Business Debts"
lab var pi_v_deb "Household Pre-imputation Vehicle Debts"
lab var pi_f_deb "Household Pre-imputation Financial Debts"
lab var b_ass "Household Business Assets"
lab var v_ass "Household Vehicle Assets"
lab var f_ass "Household Financial Assets"
lab var s_ass "Household Superannuation Assets"
lab var b_deb "Household Business Debts"
lab var v_deb "Household Vehicle Debts"
lab var f_deb "Household Financial Debts"
lab var lvstk_ass "Household Livestock Assets"
lab var p_ass "Household Possessions"
lab var pi_tot_ass "Household Pre-imputation Total Assets"
lab var pi_tot_deb "Household Pre-imputation Total Debts"
lab var tot_ass "Household Total Assets"
lab var tot_deb "Household Total Debts"
lab var pi_net_worth "Household Pre-imputation Net Worth"
lab var hhq_networth "Household One-shot Net Worth"
lab var net_worth "Household Net Worth"

order w4_hhid re_ass b_ass v_ass f_ass s_ass lvstk_ass p_ass tot_ass re_deb b_deb v_deb f_deb tot_deb pi_re_ass ///
pi_b_ass pi_v_ass pi_f_ass pi_s_ass pi_lvstk_ass pi_p_ass pi_tot_ass pi_b_deb pi_v_deb pi_f_deb pi_tot_ass ///
pi_re_deb pi_b_deb pi_v_deb pi_f_deb pi_tot_deb hhq_networth pi_net_worth net_worth

foreach var of varlist re_ass - net_worth {
rename `var' w4_`var'
}

compress

save "$DataOUT\hhderived_WEALTH", replace

*=====================================================================================================================================
* INDIVIDUAL LEVEL
* OPENING DATASET CREATED IN DO FILE "Wealth - Aggregation of imputation variables (5 of 6)"

use "$DataOUT\indwealth.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------
keep w4_hhid pid re_ass_i b_ass_i v_ass_i f_ass_i s_ass_i  p_ass_i tot_ass_i ///
			   re_deb_i b_deb_i v_deb_i f_deb_i tot_deb_i  ///
			   pi_re_ass_i pi_b_ass_i pi_v_ass_i pi_f_ass_i pi_s_ass_i pi_p_ass_i pi_tot_ass_i ///
			   pi_re_deb_i pi_b_deb_i pi_v_deb_i pi_f_deb_i pi_tot_deb_i ///
			   ind_networth_i pi_net_worth_i net_worth_i
			   
lab var re_ass_i "Individual Real Estate Assets"
lab var re_deb_i "Individual Real Estate Debts"
lab var pi_re_ass_i "Individual Pre-imputation Real Estate Assets"
lab var pi_re_deb_i "Individual Pre-imputation Real Estate Debts"
lab var pi_b_ass_i "Individual Pre-imputation Business Assets"
lab var pi_v_ass_i "Individual Pre-imputation Vehicle Assets"
lab var pi_f_ass_i "Individual Pre-imputation Financial Assets"
lab var pi_s_ass_i "Individual Pre-imputation Retirement Annuity Assets"
lab var pi_p_ass_i "Individual Pre-imputation Possessions"
lab var pi_b_deb_i "Individual Pre-imputation Business Debts"
lab var pi_v_deb_i "Individual Pre-imputation Vehicle Debts"
lab var pi_f_deb_i "Individual Pre-imputation Financial Debts"
lab var b_ass_i "Individual Business Assets"
lab var v_ass_i "Individual Vehicle Assets"
lab var f_ass_i "Individual Financial Assets"
lab var s_ass_i "Individual Superannuation Assets"
lab var p_ass_i "Individual Possessions"
lab var b_deb_i "Individual Business Debts"
lab var v_deb_i "Individual Vehicle Debts"
lab var f_deb_i "Individual Financial Debts"
lab var pi_tot_ass_i "Individual Pre-imputation Total Assets"
lab var pi_tot_deb_i "Individual Pre-imputation Total Debts"
lab var tot_ass_i "Individual Total Assets"
lab var tot_deb_i "Individual Total Debts"
lab var pi_net_worth_i "Individual Pre-imputation Net Worth"
lab var ind_networth_i "Individual One-shot Net Worth"
lab var net_worth_i "Individual Net Worth"

order w4_hhid pid re_ass_i b_ass_i v_ass_i f_ass_i s_ass_i p_ass_i tot_ass_i ///
			   re_deb_i b_deb_i v_deb_i f_deb_i tot_deb_i  ///
			   pi_re_ass_i pi_b_ass_i pi_v_ass_i pi_f_ass_i pi_s_ass_i pi_p_ass_i pi_tot_ass_i ///
			   pi_re_deb_i pi_b_deb_i pi_v_deb_i pi_f_deb_i pi_tot_deb_i ///
			   ind_networth_i pi_net_worth_i net_worth_i

foreach var of varlist re_ass_i - net_worth_i {
rename `var' w4_`var'
}

compress

save "$DataOUT\indderived_WEALTH", replace

*==================================================================================================================================================

erase "$DataOUT\hhwealth.dta"
erase "$DataOUT\indwealth.dta"
erase "$DataOUT\impdata.dta"
erase "$DataOUT\prepdata.dta"
erase "$DataOUT\data.dta"

* end of do file
*==================================================================================================================================================

 

